/**
 * Class Complex - Defines a complex number and a few classical operations
 * 
 * @author am
 * @version 1.0 - September, 2003
 */

public class Complex
{
    private double re ;
    private double im ;

    /**
     * Create a new complex (r, i)
     * @param   r   real part
     * @param   i   imaginary part
     */
    public Complex(double r, double i) {
        re = r ;
        im = i ;
    }
    
    /**
     * Create a new complex (r,0)
     * @param   r   real part
     */
    public Complex(double r) {
        re = r ;
        im = 0 ;
    }

    /**
     * Get the real part of this complex number
     */
    public double re() {
        return re ;
    }
    
    /**
     * Get the imaginary part of this complex number
     */
    public double im() {
        return im ;
    }

    /**
     * Add a complex number to this one
     */
    public void add(Complex z) {
        re += z.re() ;
        im += z.im() ;
    }

    /**
     *  Return a string representation of this complex number
     *  @return     the string "[real part ; imaginary part]"
     */
    public String toString() {
        return "[" + re + " ; " + im + "]" ;
    }

    /**
     *  Print this complex number in the form [real part ; imaginary part]
     */
    public void println() {
        System.out.println(this.toString());
    }
    
} // end class Complex
