/**
 * Class Line - Defines a straight line ax+ by + c = 0 
 * 
 * @author am
 * @version 1.0 - September, 2003
 */

public class Line
{
    private double a ;
    private double b ;
    private double c ;

    /**
     * Create a new Line
     * @param   coeff a, b and c of the equation ax+by+c=0
     *          (suppose a!=0 or b!=0)
     */
    public Line(double a, double b, double c) {
      this.a = a ;
      this.b = b ;
      this.c = c ;
    }

    /**
     * Get coeff a of the equation ax+by+c=0 of this straight line
     */
    public double a() {
        return a ;
    }
    
    /**
     * Get coeff b of the equation ax+by+c=0 of this straight line
     */
    public double b() {
        return b ;
    }
    
    /**
     * Get coeff c of the equation ax+by+c=0 of this straight line
     */
    public double c() {
        return c ;
    }
    
    /**
     *  Return the relative position of this straight line
     *  and the straight line given in parameter
     *  @return     "IDENTICAL", "PARALLEL", "PERPENDICULAR", 
     *              "SECANT", or, if error, ""
     */
    public String relativePosition(Line l) {
      String position ;
      double d, dl ;

      // If one of the two objects isn't a straight line ...
      if ( ( a==0 && b==0 ) || ( l.a==0 && l.b==0 ) ) return "" ;

      // If both are straight lines ...
      if ( a*l.b == l.a*b ) {   // if1

         if ( a!=0 ) {      // current line isn't horizontal
          d = a ; 
          dl = l.a ; 
         } 
         else {             // current line is horizontal
          d = b ; 
          dl = l.b ; 
         }

         if ( d*l.c == dl*c )
          position = "IDENTICAL" ;
           else
          position = "PARALLEL" ;
       }                    
       else {               // else if1
         if ( a*l.a ==  - b*l.b )
          position = "PERPENDICULAR" ;
           else
          position = "SECANT" ; 
       }                    // end if1

       return position ;

    } // end relativePosition

} // end class Line

