
/**
 * This class represents a simple picture. You can draw the picture using
 * the draw method. But wait, there's more: being an electronic picture, it
 * can be changed. You can set it to black-and-white display and back to
 * colors (only after it's been drawn, of course).
 *
 * This class was written as an early example for teaching Java with BlueJ.
 * 
 * @author  Michael Kolling and David J. Barnes, modified Morelle
 * @version 1.3  (June 2004)
 */

public class Picture 
{
    private Square wall;
    private Square window;
    private Triangle roof;
    private Circle sun;
    private Circle sun2;

    /**
     * Constructor - Build this picture
     */
    public Picture()
    {
        wall = new Square();
        wall.moveVertical(80);
        wall.changeSize(100);

        window = new Square();
        window.changeColor("black");
        window.moveHorizontal(20);
        window.moveVertical(100);

        roof = new Triangle();  
        roof.changeSize(50, 140);
        roof.moveHorizontal(60);
        roof.moveVertical(70);

        sun = new Circle();
        sun.changeColor("yellow");
        sun.moveHorizontal(180);
        sun.moveVertical(-10);
        sun.changeSize(60);

        sun2 = new Circle();
        sun2.changeColor("red");
        sun2.moveHorizontal(180);
        sun2.moveVertical(-10);
        sun2.changeSize(30);
    }

    /**
     * Draw this picture.
     */
    public void draw()
    {
        wall.makeVisible();      
        window.makeVisible();
        roof.makeVisible();
        sun.makeVisible();
        sun2.makeVisible();
    }
        
    /**
     * Change this picture to black/white display
     */
    public void setBlackAndWhite()
    {
        if(wall != null)   // only if it's painted already...
        {
            wall.changeColor("black");
            window.changeColor("white");
            roof.changeColor("black");
            sun.changeColor("black");
            sun2.changeColor("black");
        }
    }

    /**
     * Change this picture to use color display
     */
    public void setColor()
    {
        if(wall != null)   // only if it's painted already...
        {
            wall.changeColor("red");
            window.changeColor("black");
            roof.changeColor("green");
            sun.changeColor("yellow");
            sun2.changeColor("red");
        }
    }
    
    /**
     * Print the position of each sun of the picture
     */
    public void printSunPositions() {
        int p ;
       
        p = sun.getPosition();
        System.out.println("sun     x = " + p/1000 + "  y = " + p%1000) ;
 
        p = sun2.getPosition();
        System.out.println("sun2    x = " + p/1000 + "  y = " + p%1000) ;
    }

} // end class Picture
